# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

get_component_ <- function(urls, component) {
    .Call('urltools_get_component_', PACKAGE = 'urltools', urls, component)
}

set_component_ <- function(urls, component, new_value) {
    .Call('urltools_set_component_', PACKAGE = 'urltools', urls, component, new_value)
}

#'@title Encode or decode a URI
#'@description encodes or decodes a URI/URL
#'
#'@param urls a vector of URLs to decode or encode.
#'
#'@details
#'URL encoding and decoding is an essential prerequisite to proper web interaction
#'and data analysis around things like server-side logs. The
#'\href{http://tools.ietf.org/html/rfc3986}{relevant IETF RfC} mandates the percentage-encoding
#'of non-Latin characters, including things like slashes, unless those are reserved.
#'
#'Base R provides \code{\link{URLdecode}} and \code{\link{URLencode}}, which handle
#'URL encoding - in theory. In practise, they have a set of substantial problems
#'that the urltools implementation solves::
#'
#'\itemize{
#' \item{No vectorisation: }{Both base R functions operate on single URLs, not vectors of URLs.
#'       This means that, when confronted with a vector of URLs that need encoding or
#'       decoding, your only option is to loop from within R. This can be incredibly
#'       computationally costly with large datasets. url_encode and url_decode are
#'       implemented in C++ and entirely vectorised, allowing for a substantial
#'       performance improvement.}
#' \item{No scheme recognition: }{encoding the slashes in, say, http://, is a good way
#'       of making sure your URL no longer works. Because of this, the only thing
#'       you can encode in URLencode (unless you refuse to encode reserved characters)
#'       is a partial URL, lacking the initial scheme, which requires additional operations
#'       to set up and increases the complexity of encoding or decoding. url_encode
#'       detects the protocol and silently splits it off, leaving it unencoded to ensure
#'       that the resulting URL is valid.}
#' \item{ASCII NULs: }{Server side data can get very messy and sometimes include out-of-range
#'       characters. Unfortunately, URLdecode's response to these characters is to convert
#'       them to NULs, which R can't handle, at which point your URLdecode call breaks.
#'       \code{url_decode} simply ignores them.}
#'}
#'
#'@return a character vector containing the encoded (or decoded) versions of "urls".
#'
#'@examples
#'
#'url_decode("https://en.wikipedia.org/wiki/File:Vice_City_Public_Radio_%28logo%29.jpg")
#'url_encode("https://en.wikipedia.org/wiki/File:Vice_City_Public_Radio_(logo).jpg")
#'
#'\dontrun{
#'#A demonstrator of the contrasting behaviours around out-of-range characters
#'URLdecode("%gIL")
#'url_decode("%gIL")
#'}
#'@rdname encoder
#'@export
url_decode <- function(urls) {
    .Call('urltools_url_decode', PACKAGE = 'urltools', urls)
}

#'@rdname encoder
#'@export
url_encode <- function(urls) {
    .Call('urltools_url_encode', PACKAGE = 'urltools', urls)
}

#'@title get the values of a URL's parameters
#'@description URLs can have parameters, taking the form of \code{name=value}, chained together
#'with \code{&} symbols. \code{url_parameters}, when provided with a vector of URLs and a vector
#'of parameter names, will generate a data.frame consisting of the values of each parameter
#'for each URL.
#'
#'@param urls a vector of URLs
#'
#'@param parameter_names a vector of parameter names
#'
#'@return a data.frame containing one column for each provided parameter name. Values that
#'cannot be found within a particular URL are represented by an empty string.
#'
#'@examples
#'#A very simple example
#'url <- "https://google.com:80/foo.php?this_parameter=selfreferencing&hiphop=awesome"
#'parameter_values <- url_parameters(url, c("this_parameter","hiphop"))
#'
#'@seealso \code{\link{url_parse}} for decomposing URLs into their constituent parts.
#'
#'@export
url_parameters <- function(urls, parameter_names) {
    .Call('urltools_url_parameters', PACKAGE = 'urltools', urls, parameter_names)
}

#'@title split URLs into their component parts
#'@description \code{url_parse} takes a vector of URLs and splits each one into its component
#'parts, as recognised by RfC 3986.
#'
#'@param urls a vector of URLs
#'
#'@details It's useful to be able to take a URL and split it out into its component parts - 
#'for the purpose of hostname extraction, for example, or analysing API calls. This functionality
#'is not provided in base R, although it is provided in \code{\link[httr]{parse_url}}; that
#'implementation is entirely in R, uses regular expressions, and is not vectorised. It's
#'perfectly suitable for the intended purpose (decomposition in the context of automated
#'HTTP requests from R), but not for large-scale analysis.
#'
#'@return a data.frame consisting of the columns scheme, domain, port, path, query
#'and fragment. See the '\href{http://tools.ietf.org/html/rfc3986}{relevant IETF RfC} for
#'definitions. If an element cannot be identified, it is represented by an empty string.
#'
#'@examples
#'url_parse("https://en.wikipedia.org/wiki/Article")
#'
#'@seealso \code{\link{url_parameters}} for extracting values associated with particular keys in a URL's
#'query string, and \code{\link{url_compose}}, which is \code{url_parse} in reverse.
#'
#'@export
url_parse <- function(urls) {
    .Call('urltools_url_parse', PACKAGE = 'urltools', urls)
}

#'@title Recompose Parsed URLs
#'
#'@description Sometimes you want to take a vector of URLs, parse them, perform
#'some operations and then rebuild them. \code{url_compose} takes a data.frame produced
#'by \code{\link{url_parse}} and rebuilds it into a vector of full URLs (or: URLs as full
#'as the vector initially thrown into url_parse).
#'
#'This is currently a `beta` feature; please do report bugs if you find them.
#'
#'@param parsed_urls a data.frame sourced from \code{\link{url_parse}}
#'
#'@seealso \code{\link{scheme}} and other accessors, which you may want to
#'run URLs through before composing them to modify individual values.
#'
#'@examples
#'#Parse a URL and compose it
#'url <- "http://en.wikipedia.org"
#'url_compose(url_parse(url))
#'
#'@export
url_compose <- function(parsed_urls) {
    .Call('urltools_url_compose', PACKAGE = 'urltools', parsed_urls)
}

