% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subMultiple.r
\name{subVector}
\alias{subVector}
\alias{subMultiple}
\title{subVector}
\usage{
subVector(x, toSub)

subMultiple(x, pattern, replacement)
}
\arguments{
\item{x}{Vector of text to search}

\item{toSub}{Named vector where the elements are the pattern and the names are the replacement values}

\item{pattern}{Vector of patterns to find in each element of x}

\item{replacement}{Vector of replacement values corresponding to each value of pattern}
}
\value{
The text in x with substitutions made
}
\description{
Substitutes multiple patterns and corresponding replacements
}
\details{
Given a vector of text replaces all patterns each each element
}
\examples{
theText <- c('Hi Bob & Cooper how is life today', 
'Anything happening now?', 
'Sally & Dave are playing with Jess & Julio | with their kids')
subVector(theText, toSub=c("and"='&', 'or'='\\\\|'))
subVector(theText)

theText <- c('Hi Bob & Cooper how is life today', 
'Anything happening now?', 
'Sally & Dave are playing with Jess & Julio | with their kids')
subMultiple(theText, pattern=c('&', '\\\\|'), replacement=c('and', 'or'))

}
\author{
Jared P. Lander
}
