% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{usmap_transform}
\alias{usmap_transform}
\alias{usmap_transform.data.frame}
\title{Convert coordinate date frame to usmap projection}
\usage{
usmap_transform(data)

\method{usmap_transform}{data.frame}(data)
}
\arguments{
\item{data}{A data frame containing coordinates in a two column format
where the first column represents longitude and the second data frame
represents latitude. The names of the data frame column do not matter,
just that the order of the columns is kept intact.}
}
\value{
A data frame containing the transformed coordinates from the
  input data frame with the Albers Equal Area projection applied. The
  transformed columns will be appended to the data frame so that all
  original columns should remain intact.
}
\description{
Converting an external data frame of map coordinates will
  allow those points to line up with the regular usmap plot by applying
  the same Albers Equal Area projection to those points as well.
}
\examples{
data <- data.frame(
  lon = c(-74.01, -95.36, -118.24, -87.65, -134.42, -157.86),
  lat = c(40.71, 29.76, 34.05, 41.85, 58.30, 21.31),
  pop = c(8398748, 2325502, 3990456, 2705994, 32113, 347397)
)

# Transform data
transformed_data <- usmap_transform(data)

# Plot transformed data on map
library(ggplot2)

plot_usmap() + geom_point(
  data = transformed_data,
  aes(x = lon.1, y = lat.1, size = pop),
  color = "red", alpha = 0.5
)

}
