% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test_hypothesis}
\alias{test_hypothesis}
\title{Test the null hypothesis}
\usage{
test_hypothesis(x, y, parametric, digits, p.digits)
}
\arguments{
\item{x}{A numeric or factor. Observations.}

\item{y}{A factor. Factor to stratify by.}

\item{parametric}{A logical. Indicates parametric testing should be used.
See note detailing statistical tests.}

\item{digits}{An integer. Number of digits to round to.}

\item{p.digits}{An integer. Number of p-value digits to print. Note that
p-values are still rounded using 'digits'.}
}
\value{
A character formatted p-value.
}
\description{
Produces a p-value from parametric or non-parametric testing of the
null hypothesis for stratified data.
}
\note{
Statistical testing used is dependent on type of 'x' data, number of
levels in the factor 'y', and whether parametric/non-parametric testing is
selected. For continuous 'x' data, parametric testing is Student's t-test
(y, 2 lvls) or one-way ANOVA (y, >2 lvls). Non-parametric testing is
Wilcoxon Rank Sum/Mann Whitney U (y, 2 lvls) or Kruskal Wallis (y, >2 lvls).
For factor or logical 'x' data, "parametric" testing is Chi-squared with
(x, 2 lvls) and without (x, >2 lvls) Monte Carlo simulation. Non-parametric
testing is the Fisher's exact test with (x, 2 lvls) and without (x, >2 lvls)
Monte Carlo simulation.
}
\examples{
# Numeric data
test_hypothesis(mtcars$mpg, as.factor(mtcars$gear))

# Logical data
test_hypothesis(as.logical(mtcars$vs), as.factor(mtcars$gear))

# Factor data
test_hypothesis(as.factor(mtcars$carb), as.factor(mtcars$gear))
}
