% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{chunk_data_}
\alias{chunk_data_}
\title{Break data into chunks}
\usage{
chunk_data_(x, size = 10, reverse = FALSE)
}
\arguments{
\item{x}{A data frame or vector.}

\item{size}{An integer. The number of items (e.g. rows in a tibble)
that make up a given chunk. Must be a positive integer.}

\item{reverse}{A logical. Calculate chunks from back to front.}
}
\value{
A factory function which returns a chunk of data from the provided
object with each call. Once all data has been returned, function returns
NULL perpetually.
}
\description{
Creates a factory function which returns a different chunk
of a given data object with each function call.
}
\examples{
# Create chunk factory function
chunked_data <- chunk_data_(mtcars, size = 6)

# Chunk #1 (rows 1-6)
paste0(rownames(chunked_data()), collapse = ', ')

# Chunk #2 (rows 7-12)
paste0(rownames(chunked_data()), collapse = ', ')
}
