% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{bbase}
\alias{bbase}
\title{Constructs a B-spline basis of degree 'deg' (Code by Paul Eilers, Package JOPS, http://statweb.lsu.edu/faculty/marx/JOPS_0.1.0.tar.gz).}
\usage{
bbase(x, xl = min(x), xr = max(x), ndx = 20, deg = 6)
}
\arguments{
\item{x}{values for the x axis.}

\item{xl}{minimum value, default is the minimum value of the x-values.}

\item{xr}{maximum value, default is maximum value of the x-values.}

\item{ndx}{number of intervals to partition the distance between xl and xr.}

\item{deg}{degree of the B-spline basis.}
}
\value{
a B-spline basis of degree deg and ndx + 1 internal knots.
}
\description{
Constructs a B-spline basis of degree 'deg' (Code by Paul Eilers, Package JOPS, http://statweb.lsu.edu/faculty/marx/JOPS_0.1.0.tar.gz).
}
\examples{
x_finegrid <- seq(0.001, 1.0, (1.0 - 0.001) / 1000)
bbase(x_finegrid)
}
