#' Toy multi-label dataset.
#'
#' A toy multi-label dataset is a synthetic dataset generated by the tool
#' \url{http://sites.labic.icmc.usp.br/mldatagen/} using the Hyperspheres
#' strategy. Its purpose is to be used for small tests and examples.
#'
#' @format A mldr object with 100 instances, 10 features and 5 labels:
#' \describe{
#'   \item{att1}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att2}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att3}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att4}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att5}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att6}{Relevant numeric attribute between (-1 and 1)}
#'   \item{att7}{Relevant numeric attribute between (-1 and 1)}
#'   \item{iatt8}{Irrelevant numeric attribute between (-1 and 1)}
#'   \item{iatt9}{Irrelevant numeric attribute between (-1 and 1)}
#'   \item{ratt10}{Redundant numeric attribute between (-1 and 1)}
#'   \item{y1}{Label 'y1' - Frequency: 0.17}
#'   \item{y2}{Label 'y2' - Frequency: 0.78}
#'   \item{y3}{Label 'y3' - Frequency: 0.19}
#'   \item{y4}{Label 'y4' - Frequency: 0.69}
#'   \item{y5}{Label 'y5' - Frequency: 0.17}
#' }
#'
#' @details General Information
#' \itemize{
#'  \item Cardinality: 2
#'  \item Density: 0.4
#'  \item Distinct multi-labels: 18
#'  \item Number of single labelsets: 5
#'  \item Max frequency: 23
#' }
#'
#' @source Generated by \url{http://sites.labic.icmc.usp.br/mldatagen/}
#' Configuration:
#' \itemize{
#'   \item Strategy: Hyperspheres
#'   \item Relevant Features: 7
#'   \item Irrelevant Features: 2
#'   \item Redundant Features: 1
#'   \item Number of Labels (q): 5
#'   \item Number of Instances: 100
#'   \item Noise (from 0 to 1): 0.05
#'   \item Maximum Radius/Half-Edge of the Hyperspheres/Hypercubes: 0.8
#'   \item Minimum Radius/Half-Edge of the Hyperspheres/Hypercubes: ((q/10)+1)/q
#' }
"toyml"
