% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dynamics_proteome.R
\name{plot_dynamics_proteome}
\alias{plot_dynamics_proteome}
\title{Dynamics of Diversity Motifs (Proteome) Plot}
\usage{
plot_dynamics_proteome(
  df,
  host = 1,
  line_dot_size = 2,
  base_size = 10,
  alpha = 1/3,
  bw = "nrd0",
  adjust = 1
)
}
\arguments{
\item{df}{DiMA JSON converted csv file data}

\item{host}{number of host (1/2)}

\item{line_dot_size}{size of dot in plot}

\item{base_size}{word size in plot}

\item{alpha}{any number from 0 (transparent) to 1 (opaque)}

\item{bw}{smoothing bandwidth of violin plot (default: nrd0)}

\item{adjust}{adjust the width of violin plot (default: 1)}
}
\value{
A plot
}
\description{
This function compactly display the dynamics of diversity motifs (index and its variants: major, minor and unique)
in the form of dot plot as well as violin plot for all the provided proteins at proteome level.
}
\examples{
plot_dynamics_proteome(proteins_1host)
}
