% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip}
\alias{pip}
\title{Posterior Inclusion Probabilities}
\usage{
pip(object, ...)
}
\arguments{
\item{object}{Ab object of class \code{vicc}.}

\item{...}{Currently ignored.}
}
\value{
A data frame.
}
\description{
Extract the posterior inclusion probabilities (PIP) for either the
             random intercepts for sigma or the random effects standard deviation
             for sigma.
}
\note{
The PIPs indicate whether the groups differ from the fixed effect, or average,
      within-group variance. If the PIP is large, this indicates there is high probability
      that group differs from the common variance. A marginal Bayes factor can be computed
      as PIP / (1 - PIP), assuming that \code{prior_prob = 0.5}.
}
\examples{
\donttest{

# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]

# fit model
fit <- vicc(y  = dat$rt,
            group = dat$id,
            iter = 250,
            burnin = 10,
            type =  "pick_group")

pip(fit)
}
}
