% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regexSeriesLabel.R
\name{regexSeriesLabel}
\alias{regexSeriesLabel}
\title{Searches for matches in series' labels}
\usage{
regexSeriesLabel(pattern = NULL, ...)
}
\arguments{
\item{pattern}{character string as regular expression. Only accepts character string. If length is greater than 1, the first element is used. Defaults to \code{NULL}.
The default option returns a \code{data.frame} with all series with labels and links in the API.}

\item{...}{accepts the follwing extra arguments from \code{\link[base]{grep}}: \code{ignore.case}, \code{perl}, \code{fixed} and
\code{useBytes}.}
}
\value{
A \code{data.frame}. Columns are the series label, link and name respectively.
}
\description{
Exploratory function. If the pattern successfuly matches one or more series labels, then a
\code{data.frame} is returned with the series label and link. The link can be used in the function \code{\link{getSeriesData}} to fetch
the data.
}
\examples{
# get a list of series that matches the pattern "CPI"

\donttest{
#'
cpiList <- regexSeriesLabel(pattern="cpi") # no match, returns an empty data.frame
cpiList2 <- regexSeriesLabel(pattern="cpi", ignore.case=TRUE) # finds match
}
}
\seealso{
\code{\link{getSeriesInfo}}, \code{\link[base]{grep}}
}
