% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_closest.r
\name{bed_closest}
\alias{bed_closest}
\title{Identify closest intervals.}
\usage{
bed_closest(x, y, overlap = TRUE, suffix = c(".x", ".y"),
  dist = c("genome", "strand", "abs"))
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{overlap}{report overlapping intervals}

\item{suffix}{colname suffixes in output}

\item{dist}{format for distance to nearest interval}
}
\value{
\code{data_frame} with additional columns:
  \itemize{
    \item{\code{.dist}}{ distance to closest interval}
    \item{\code{.overlap}}{ overlap with closest interval}
  }
}
\description{
Identify closest intervals.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
  groups can be added using \code{\link[dplyr]{group_by}}. For example,
  grouping by \code{strand} will constrain analyses to the same strand. To
  compare opposing strands across two tbls, strands on the \code{y} tbl can
  first be inverted using \code{\link{flip_strands}}.

\code{dist} can take one of the following values:
  \itemize{
    \item{\code{genome}}{ negative distances signify upstream intervals (default)}
    \item{\code{strand}}{ upstream defined based on strand}
    \item{\code{abs}}{ absolute value of distance}}
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',      100,     125
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',      25,      50,
  'chr1',     140,     175
)
 
bed_glyph(bed_closest(x, y))

x <- tibble::tribble(
~chrom, ~start, ~end,
"chr1", 500,    600,
"chr2", 5000,   6000
) 

y <- tibble::tribble(
~chrom, ~start, ~end,
"chr1", 100,    200,
"chr1", 150,    200,
"chr1", 550,    580,
"chr2", 7000,   8500
) 

bed_closest(x, y)

bed_closest(x, y, overlap = FALSE)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/closest.html}

Other multi-set-ops: \code{\link{bed_coverage}},
  \code{\link{bed_intersect}}, \code{\link{bed_map}},
  \code{\link{bed_subtract}}, \code{\link{bed_window}}
}

