% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ExtractFileTimeStamp}
\alias{ExtractFileTimeStamp}
\title{Extract Filename Time Stamp}
\usage{
ExtractFileTimeStamp(filename)
}
\arguments{
\item{filename}{String of the file name to extract the \emph{\strong{FileTimeStamp}}
information}
}
\value{
A string with the date and time.
}
\description{
Extract date & time stamp from a file
}
\details{
Create a date-time string to append to filenames to try and make
them unique. The date-time string has the format
month-day-year_hour-minute; for example, May 4, 2016 at 12:34pm is
represented as \code{may042016_1234}.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  filename <- "ConservedWaters_PASSED_may042016_1234.pdb"
  ExtractFileTimeStamp(filename)
  # [1] may042016_1234
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
