% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-package.R
\docType{data}
\name{sst_c}
\alias{sst_c}
\title{SST contours}
\description{
Southern Ocean GHRSST contours in sf data frame from 2017-07-28, read from
}
\details{
podaac-ftp.jpl.nasa.gov/allData/ghrsst/data/GDS2/L4
GLOB/JPL/MUR/v4.1/2017/209/
20170728090000-JPL-L4_GHRSST-SSTfnd-MUR-GLOB-v02.0-fv04.1.nc

See data-raw/sst_c.R for the derivation column \code{sst_c} in Celsius.

Also stored in GeoPackage format in
\code{system.file("extdata/sst_c.gpkg", package = "vapour")}
}
\examples{
## library(sf)
## plot(sst_c)
f <- system.file("extdata/sst_c.gpkg", package = "vapour")

## create an equivalent but class-less form of sst_c  with GeoJSON rather than sf sfc format
atts <- vapour_read_attributes(f)
dat <- as.data.frame(atts, stringsAsFactors = FALSE)
dat[["json"]] <- vapour_read_geometry_text(f)
names(dat)
names(sst_c)
}
