% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.target.qc.R
\name{run.target.qc}
\alias{run.target.qc}
\title{Perform sample QC by looking at target coverage.}
\usage{
run.target.qc(bam.specification, project.directory,
  sample.directories = TRUE, paired = FALSE,
  output.subdirectory = FALSE, quiet = FALSE, job.name.prefix = NULL,
  verify.options = FALSE, job.group = "target_qc")
}
\arguments{
\item{bam.specification}{Data frame containing details of BAM files to be processed, typically from \code{prepare.bam.specification}.}

\item{project.directory}{Path to project directory where code and log files should be saved}

\item{sample.directories}{Logical indicating whether output for each sample should be put in its own directory (within output.directory)}

\item{paired}{Logical indicating whether the analysis is paired. This does not affect QC directly, but means normal samples get nested}

\item{output.subdirectory}{If further nesting is required, name of subdirectory. If no further nesting, set to FALSE}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit the job}

\item{job.name.prefix}{Prefix for job names on the cluster}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}

\item{job.group}{Group job should be associated with on cluster}
}
\description{
Perform sample QC by looking at target coverage.
}
