\name{causality}

\alias{causality}

\title{Causality Analysis}

\encoding{latin1}

\description{
  Computes the test statistics for Granger- and Instantaneous causality
  for a VAR(p). 
}

\usage{
causality(x, cause = NULL, vcov.=NULL, boot=FALSE, boot.runs=100)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.} 
  \item{cause}{A character vector of the cause variable(s). If not set,
    then the variable in the first column of \code{x$y} is used as cause
    variable and a warning is printed.}   
  \item{vcov.}{a specification of the covariance matrix of the estimated coefficients. This can be
    specified as a matrix or as a function yielding a matrix when applied to \code{x}.}
  \item{boot}{Logical. Whether a wild bootstrap procedure should be used to compute the critical values. Default is no}
  \item{boot.runs}{Number of bootstrap replications if boot=TRUE}
}

\details{
  Two causality tests are implemented. The first is a F-type
  Granger-causality test and the second is a Wald-type test that is
  characterized by testing for nonzero correlation between the error
  processes of the cause and effect variables. For both tests the vector
  of endogenous variables \eqn{\bold{y}_t} is split into two subvectors
  \eqn{\bold{y}_{1t}} and \eqn{\bold{y}_{2t}} with dimensions \eqn{(K_1
    \times 1)} and \eqn{(K_2 \times 1)} with \eqn{K = K_1 + K_2}.\cr
  For the rewritten VAR(p):

  \deqn{
    [\bold{y}_{1t} , \bold{y}_{2t}] = \sum_{i=1}^p [\bold{\alpha}_{11, i}' ,
    \bold{\alpha}_{12, i}' | \bold{\alpha}_{21, i}' , \bold{\alpha}_{22,
      i}'][\bold{y}_{1,t-i}, \bold{y}_{2, t-i}] + CD_t + [\bold{u}_{1t},
    \bold{u}_{2t}]  \quad ,
  }
  the null hypothesis that the subvector \eqn{\bold{y}_{1t}} does not
  Granger-cause \eqn{\bold{y}_{2t}}, is defined as
  \eqn{\bold{\alpha}_{21, i} = 0} for \eqn{i = 1, 2, \ldots, p}. The
  alternative is: \eqn{\exists \; \bold{\alpha}_{21,i} \ne 0} for \eqn{i =
    1, 2, \ldots, p}. The test statistic is distributed as \eqn{F(p K_1
    K_2, KT - n^*)}, with \eqn{n^*} equal to the total number of
  parameters in the above VAR(p) (including deterministic
  regressors).\cr
  The null hypothesis for instantaneous causality is defined as:
  \eqn{H_0: C \bold{\sigma} = 0}, where \eqn{C} is a \eqn{(N \times K(K
    + 1)/2)} matrix of rank \eqn{N} selecting the relevant co-variances of
  \eqn{\bold{u}_{1t}} and \eqn{\bold{u}_{2t}}; \eqn{\bold{\sigma} =
    vech(\Sigma_u)}. The Wald statistic is defined as:
  \deqn{
    \lambda_W = T \tilde{\bold{\sigma}}'C'[2 C D_{K}^{+}(\tilde{\Sigma}_u
    \otimes \tilde{\Sigma}_u) D_{K}^{+'} C']^{-1} C
    \tilde{\bold{\sigma}}  \quad , 
  }
  hereby assigning the Moore-Penrose inverse of the duplication matrix
  \eqn{D_K} with \eqn{D_{K}^{+}} and \eqn{\tilde{\Sigma}_u =
    \frac{1}{T}\sum_{t=1}^T \hat{\bold{u}}_t \hat{\bold{u}}_t'}. The
  duplication matrix \eqn{D_K} has dimension \eqn{(K^2 \times
    \frac{1}{2}K(K + 1))} and is defined such that for any symmetric
  \eqn{(K \times K)} matrix A, \eqn{vec(A) = D_K vech(A)} holds. The
  test statistic \eqn{\lambda_W} is asymptotically distributed as
  \eqn{\chi^2(N)}.
  
  Fot the Granger causality test, a robust covariance-matrix estimator can be 
  used in case of heteroskedasticity through argument \code{vcov.} It can be either a pre-computed matrix or
  a function for extracting the covariance matrix. See \code{\link[sandwich]{vcovHC}}
  from package \pkg{sandwich} for further details. 

  A wild bootstrap computation (imposing the restricted model as null)
  of the p values is available through argument \code{boot} and \code{boot.runs} following Hafner and Herwartz (2009). 
}

\value{
  A list with elements of class \sQuote{\code{htest}}:\cr
  
  \item{Granger}{The result of the Granger-causality test.}
  \item{Instant}{The result of the instantaneous causality test.}
}

\note{The Moore-Penrose inverse matrix is computed with the function
  \code{\link[MASS]{ginv}} contained in the package \sQuote{\code{MASS}}.\cr
  The Granger-causality test is problematic if some of the
  variables are nonstationary. In that case the usual asymptotic
  distribution of the test statistic may not be valid under the null
  hypothesis.  
}

\author{Bernhard Pfaff}

\references{
  Granger, C. W. J. (1969), Investigating causal relations by
  econometric models and cross-spectral methods, \emph{Econometrica},
  \bold{37}: 424-438. 

  Hafner, C. M. and Herwartz, H. (2009) Testing for linear vector autoregressive 
  dynamics under multivariate generalized autoregressive heteroskedasticity, 
  \emph{Statistica Neerlandica}, \bold{63}: 294-323

  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
  
  Venables, W. N. and B. D. Ripley (2002), \emph{Modern Applied
    Statistics with S}, 4th edition, Springer, New York.

  Zeileis, A. (2006) Object-Oriented Computation of Sandwich Estimators
  \emph{Journal of Statistical Software}, \bold{16}, 1-16
}

\seealso{
  \code{\link{VAR}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
causality(var.2c, cause = "e")

#use a robust HC variance-covariance matrix for the Granger test:
causality(var.2c, cause = "e", vcov.=vcovHC(var.2c))

#use a wild-bootstrap procedure to for the Granger test
\dontrun{causality(var.2c, cause = "e", boot=TRUE, boot.runs=1000)}
}

\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{Causality}
\concept{Granger Causality}
\concept{Instantaneous Causality}


