"serial.test" <-
function(x, lags.pt = 16, lags.bg = 5, type = c("PT.asymptotic", "PT.adjusted", "BG", "ES")){
  if(!((class(x)=="varest") || (class(x)=="vec2var"))){
    stop("\nPlease provide an object of class 'varest', generated by 'var()', or an object of class 'vec2var' generated by 'vec2var()'.\n")
  }
  obj.name <- deparse(substitute(x))
  type <- match.arg(type)
  K <- x$K
  obs <- x$obs
  resids <- resid(x)
  if((type == "PT.asymptotic") || (type == "PT.adjusted")){
    lags.pt <- abs(as.integer(lags.pt))
    ptm <- .pt.multi(x, K = K, obs = obs, lags.pt = lags.pt, obj.name = obj.name, resids = resids)    
    ifelse(type == "PT.asymptotic", test <- ptm[[1]], test <- ptm[[2]])
  } else {
    lags.bg <- abs(as.integer(lags.bg))
    bgm <- .bgserial(x, K = K, obs = obs, lags.bg = lags.bg, obj.name = obj.name, resids = resids)
    ifelse(type == "BG", test <- bgm[[1]], test <- bgm[[2]])
  }
  result <- list(resid = resids, serial = test)
  class(result) <- "varcheck"
  return(result)
}
serial <- function(x, lags.pt = 16, lags.bg = 5, type = c("PT.asymptotic", "PT.adjusted", "BG", "ES")){
  .Deprecated("serial.test", package = "vars", msg = "Function 'serial' is deprecated; use 'serial.test' instead.\nSee help(\"vars-deprecated\") and help(\"serial-deprecated\") for more information.")
  serial.test(x = x, lags.pt = lags.pt, lags.bg = lags.bg, type = type)
}
