"fevd.svecest" <-
function(x, n.ahead=10, ...){
  if(!is(x, "svecest")){
    stop("\nPlease provide an object of class 'svecest', generated by 'SVEC()'.\n")
  }
  n.ahead <- abs(as.integer(n.ahead))
  ifelse(is.null(x$call$r), r <- 1, r <- x$call$r)
  varlevel <- vec2var(x$var, r = r)  
  K <- varlevel$K
  p <- varlevel$p
  ynames <- colnames(varlevel$datamat[, 1 : K])
  msey <- .fecovsvec(x, n.ahead = n.ahead, K = K)
  Phi <- Phi(x, nstep = n.ahead)
  mse <- matrix(NA, nrow = n.ahead, ncol = K)
  Omega <- array(0, dim = c(n.ahead, K, K))
  for(i in 1 : n.ahead){
    mse[i, ] <- diag(msey[, , i])
    temp <- matrix(0, K, K)
    for(j in 1 : i){
      temp <- temp + Phi[ , , j]^2
    }
    temp <- temp / mse[i, ]
    for(j in 1 : K){
      Omega[i, ,j] <- temp[j, ]
    }
  }
  result <- list()
  for(i in 1 : K){
    result[[i]] <- matrix(Omega[, , i], nrow = n.ahead, ncol = K)
    colnames(result[[i]]) <- ynames
  }
  names(result) <- ynames
  class(result) <- "varfevd"
  return(result)
}
