% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{c,ScriptOutput-method}
\alias{c}
\alias{c,ScriptOutput-method}
\title{Concatenate ScriptOutput objects together.}
\usage{
\S4method{c}{ScriptOutput}(x, ..., recursive = FALSE)
}
\arguments{
\item{x}{The first \code{\link[=ScriptOutput-class]{ScriptOutput}} object.}

\item{...}{Others \code{\link[=ScriptOutput-class]{ScriptOutput}} object to be concatened.}

\item{recursive}{logical.  If \code{recursive = TRUE}, the function
    recursively descends through lists (and pairlists) combining all
    their elements into a vector.}
}
\description{
Concatenate ScriptOutput objects together.
}
\details{
This is a \code{\link{c}} method specific for \code{\link[=ScriptOutput-class]{ScriptOutput}} objects. All \code{\link[=ScriptOutput-class]{ScriptOutput}} objects must use the same language (\code{.R} or \code{.Rmd}). The header and the footer of the first object will be used for all. It is used in \pkg{vartors} by \code{\link{create_script}} to create a script for more than one variable.
}
\examples{
# Create a script output from a description table
myscript <- create_script(variables_description_bad_database)

# But you forget a variable.
# Create it as a VariableDef object
forgoten_var <- vardef(varlabel = "A forgotten variable", rname = "forget", type = "integer")
forgoten_var

# Create a script for it
forgoten_script <- create_script(forgoten_var)
forgoten_script

# Add it to the initial script
my_complete_script <- c(myscript, forgoten_script)

# Watch the result
\dontrun{
my_complete_script

# Write the script in a file
write_file(my_complete_script, "my_import_script.R")
}
}
\author{
Joris Muller
}
\seealso{
The \code{\link{c}} function and the \code{\link[=ScriptOutput-class]{ScriptOutput class}}.
}

