% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR_conversion.R
\name{Format conversion}
\alias{Format conversion}
\alias{vcfR2genind}
\alias{vcfR2loci}
\alias{vcfR2genlight}
\title{Convert vcfR objects to other formats}
\usage{
vcfR2genind(x, sep = "[|/]")

vcfR2loci(x)

vcfR2genlight(x, n.cores = 1)
}
\arguments{
\item{x}{an object of class chromR or vcfR}

\item{sep}{character (to be used in a regular expression) to delimit the alleles of genotypes}

\item{n.cores}{integer specifying the number of cores to use.}
}
\description{
Convert vcfR objects to objects supported by other R packages
}
\details{
After processing vcf data in vcfR, one will likely proceed to an analysis step.
Within R, three obvious choices are:
\href{https://cran.r-project.org/package=pegas}{pegas},
\href{https://cran.r-project.org/package=adegenet}{adegenet} 
and \href{https://cran.r-project.org/package=poppr}{poppr}.
The package pegas uses objects of type loci.
The function \strong{vcfR2loci} calls extract.gt to create a matrix of genotypes which is then converted into an object of type loci.

The packages adegenet and poppr use the genind object.
The function \strong{vcfR2genind} uses extract.gt to create a matrix of genotypes and uses the adegenet function df2genind to create a genind object.
The package poppr additionally uses objects of class genclone which can be created from genind objects using poppr::as.genclone.
A genind object can be converted to a genclone object with the function poppr::as.genclone.


The function vcfR2genlight calls the 'new' method for the genlight object.
This method implements multi-threading through calls to the function \code{\link[parallel]{mclapply}}.
Because 'forks' do not exist in the windows environment, this will only work for windows users when n.cores=1.
In the Unix environment, users may increase this number to allow the use of multiple threads (i.e., cores).
}
\seealso{
\code{\link{extract.gt}},
\code{\link{alleles2consensus}},
\code{\link[adegenet]{df2genind}},
\code{\link[adegenet]{genind}},
\href{https://cran.r-project.org/package=pegas}{pegas},
\href{https://cran.r-project.org/package=adegenet}{adegenet},
and 
\href{https://cran.r-project.org/package=poppr}{poppr}.
To convert to objects of class \strong{DNAbin} see \code{\link{vcfR2DNAbin}}.
}
