% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.spear}
\alias{meta.sub.spear}
\title{Confidence interval for a difference in average Spearman
correlations for two sets of studies}
\usage{
meta.sub.spear(alpha, n, cor, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of sample Spearman correlations}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - Estimate for Set A
\item Row 2 - Estimate for Set B
\item Row 3 - Estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimate of average correlation or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in average Spearman correlations for two mutually
exclusive sets of studies. Each set can have one or more studies.
}
\examples{
n <- c(55, 190, 65, 35)
cor <- c(.40, .65, .60, .45)
group <- c(1, 1, 2, 0)
meta.sub.spear(.05, n, cor, group)

# Should return:
#                Estimate         SE         LL        UL
# Set A:            0.525 0.06483629  0.3865928 0.6402793
# Set B:            0.600 0.08829277  0.3992493 0.7458512
# Set A - Set B:   -0.075 0.10954158 -0.2760700 0.1564955


}
\references{
Bonett, D.G. (2008). Meta-analytic interval estimation for bivariate
correlations. \emph{Psychological Methods}, 13, 173-189.
}
