% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.prop2}
\alias{meta.lm.prop2}
\title{Meta-regression analysis for 2-group proportion differences}
\usage{
meta.lm.prop2(alpha, f1, f2, n1, n2, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 event counts}

\item{f2}{vector of group 2 event counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a 2-group
proportion difference. The estimates are OLS estimates with
standard errors that accommodate residual heteroscedasticity.
}
\examples{
f1 <- c(24, 40, 93, 14, 5)
f2 <- c(12, 9, 28, 3, 1)
n1 <- c(204, 201, 932, 130, 77)
n2 <- c(106, 103, 415, 132, 83)
x1 <- c(4, 4, 5, 3, 26)
x2 <- c(1, 1, 1, 0, 0)
X <- matrix(cbind(x1, x2), 5, 2)
meta.lm.prop2(.05, f1, f2, n1, n2, X)

# Should return:
#        Estimate          SE          z     p          LL          UL
# b0  0.089756283 0.034538077  2.5987632 0.009  0.02206290 0.157449671
# b1 -0.001447968 0.001893097 -0.7648672 0.444 -0.00515837 0.002262434
# b2 -0.034670988 0.034125708 -1.0159786 0.310 -0.10155615 0.032214170


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
