% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.cronbach}
\alias{meta.sub.cronbach}
\title{Confidence interval for a difference in average Cronbach
reliabilities for two sets of studies}
\usage{
meta.sub.cronbach(alpha, n, rel, r, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{rel}{vector of estimated Cronbach reliabilities}

\item{r}{number of measurements (e.g., items)}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - estimate for Set A
\item Row 2 - estimate for Set B
\item Row 3 - estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimate of average correlation or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in average Cronbach reliability coefficients for two mutually
exclusive sets of studies. Each set can have one or more studies. The
number of measurements used to compute the sample reliablity coefficient
is assumed to be the same for all studies.
}
\examples{
n <- c(120, 170, 150, 135)
rel <- c(.89, .87, .73, .71)
group <- c(1, 1, 2, 2)
r <- 10
meta.sub.cronbach(.05, n, rel, r, group)

# Should return: 
#                Estimate         SE        LL        UL
# Set A:             0.88 0.01068845 0.8581268 0.8999386
# Set B:             0.72 0.02515130 0.6684484 0.7668524
# Set A - Set B:     0.16 0.02732821 0.1082933 0.2152731


}
\references{
\insertRef{Bonett2010}{vcmeta}
}
