% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.cronbach}
\alias{meta.lm.cronbach}
\title{Meta-regression analysis for Cronbach reliabilities}
\usage{
meta.lm.cronbach(alpha, n, rel, r, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{rel}{vector of estimated reliabilities}

\item{r}{number of measurements (e.g., items)}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - exponentiated OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the exponentiated confidence interval
\item UL - upper limit of the exponentiated confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a log-complement
Cronbach reliablity. The estimates are OLS estimates with robust standard
errors that accommodate residual heteroscedasticity. The exponentiated slope
estimate for a predictor variable describes a multiplicative change in
non-reliability associated with a 1-unit increase in that predictor
variable, controlling for all other predictor variables in the model.
}
\examples{
n <- c(583, 470, 546, 680)
rel <- c(.91, .89, .90, .89)
x1 <- c(1, 0, 0, 0)
X <- matrix(x1, 4, 1)
meta.lm.cronbach(.05, n, rel, 10, X)

# Should return:
#      Estimate         SE          z     p         LL          UL
# b0 -2.2408328 0.03675883 -60.960391 0.000 -2.3128788 -2.16878684
# b1 -0.1689006 0.07204625  -2.344336 0.019 -0.3101087 -0.02769259


}
\references{
\insertRef{Bonett2010}{vcmeta}
}
