% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric.R
\name{vec_math}
\alias{vec_math}
\alias{vec_math_base}
\title{Mathematical operations}
\usage{
vec_math(.fn, .x, ...)

vec_math_base(.fn, .x, ...)
}
\arguments{
\item{.fn}{A mathematical function from the base package, as a string.}

\item{.x}{A vector.}

\item{...}{Additional arguments passed to \code{.fn}.}
}
\description{
This generic provides a common dispatch mechanism for all regular unary
mathematical functions. It is used as a common wrapper around many of the
Summary group generics, the Math group generics, and a handful of other
mathematical functions like \code{mean()}.
}
\details{
\code{vec_math_base()} is provided as a convenience for writing methods. It
calls the base \code{.fn} on the underlying \code{\link[=vec_data]{vec_data()}}.
}
\section{Included functions}{

\itemize{
\item From the \link{Summary} group generic:
\code{prod()}, \code{sum()}, \code{any()}, \code{all()}.
\item From the \link{Math} group generic:
\code{abs()}, \code{sign()}, \code{sqrt()}, \code{ceiling()}, \code{floor()}, \code{trunc()}, \code{cummax()},
\code{cummin()}, \code{cumprod()}, \code{cumsum()}, \code{log()}, \code{log10()}, \code{log2()},
\code{log1p()}, \code{acos()}, \code{acosh()}, \code{asin()}, \code{asinh()}, \code{atan()}, \code{atanh()},
\code{exp()}, \code{expm1()}, \code{cos()}, \code{cosh()}, \code{cospi()}, \code{sin()}, \code{sinh()},
\code{sinpi()}, \code{tan()}, \code{tanh()}, \code{tanpi()}, \code{gamma()}, \code{lgamma()},
\code{digamma()}, \code{trigamma()}.
\item Additional generics: \code{mean()}, \code{is.nan()}, \code{is.finite()}, \code{is.infinite()}.
}
}

\examples{
x <- new_vctr(c(1, 2.5, 10))
x

abs(x)
sum(x)
cumsum(x)
}
\seealso{
\code{\link[=vec_arith]{vec_arith()}} for the equivalent for the arithmetic infix operators.
}
\keyword{internal}
