% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sampler}
\alias{sampler}
\title{Sampler Function}
\usage{
sampler(n, design, type = "spherical", at = FALSE, ...)
}
\arguments{
\item{n}{number of points to sample}

\item{design}{design for which the sample is required (either a matrix or data frame)}

\item{type}{type of design region/sampling method. One of "spherical", "cuboidal", "lhs", "mlhs", "slhs", or "rslhs"}

\item{at}{logical; should sampling be done on the surface of hyperspheres or hypercubes? Not used for LHS methods.}

\item{\dots}{other arguments passed to the underlying sampling functions.}
}
\value{
Matrix with samples as rows, with S3 class \code{smpl}
}
\description{
This is a wrapper for the sampling funcions of the \pkg{vdg} package. It extracts design properties from the
design passed to it to take appropriate samples.
}
\examples{
set.seed(1896)
sampler(n = 10, design = expand.grid(x = -1:1, y = -1:1))
}
\author{
Pieter C. Schoonees
}
\seealso{
\code{\link{runif_sphere}}, \code{\link{runif_cube}}, \code{\link{LHS}},
\code{\link{MLHS}}, \code{\link{SLHS}}, \code{\link{RSLHS}}
}

