% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_china.R
\name{ef_china}
\alias{ef_china}
\title{Emissions factors from Chinese emissions guidelines}
\usage{
ef_china(v = "PV", t = "Small", f = "G", standard, p, k = 1,
  ta = celsius(25), humidity = 0.5, altitude = 1000,
  speed = Speed(29), baseyear_det = 2016, sulphur = 50,
  load_factor = 0.5, details = FALSE, correction_only = FALSE)
}
\arguments{
\item{v}{Character; category vehicle: "PV" for Passenger Vehicles or 'Trucks"}

\item{t}{Character; sub-category of of vehicle: PV:  "Mini", "Small","Medium",
"Large", "Taxi", "Motorcycles", "Moped", "Mediumbus", "Largebus", "3-Wheel" Trucks:
"Mini", "Light" , "Medium", "Heavy"}

\item{f}{Character;fuel: "G", "D"}

\item{standard}{Character or data.frame; "PRE", "I", "II", "III", "IV", "V". When
it is a data.frame, it each row is a different region and ta, humidity,
altitud, speed, sulphur and load_factor lengths have the same as the number of
rows.}

\item{p}{Character; pollutant: "CO", "NOx","HC", "PM"}

\item{k}{Numeric; multiplication factor}

\item{ta}{Numeric; temperature of ambient in celcius degrees. When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{humidity}{Numeric; relative humidity. When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{altitude}{Numeric; altitude in meters. When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{speed}{Numeric; altitude in km/h When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{baseyear_det}{Integer; any of 2014, 2015, 2016, 2017, 2018}

\item{sulphur}{Numeric; sulphur in ppm. When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{load_factor}{Numeric; When standard is a
data.frame, the length must be equal to the number of rows of standard.}

\item{details}{Logical; When TRUE, it shows a description of the vehicle in chinese
and english. Only when length standard is 1.}

\item{correction_only}{Logical; When TRUE, return only correction factors.}
}
\value{
An emission factor
}
\description{
\code{\link{ef_china}} returns emission factors as vector or data.frames.
The emission factors  comes from the chinese emission guidelines (v3) from the
Chinese Ministry of Ecology and Environment
http://www.mee.gov.cn/gkml/hbb/bgth/201407/W020140708387895271474.pdf
}
\examples{
{
# when standard is 'character'
ef_china(standard = c("I"), p = "CO", details = TRUE)
ef_china(standard = c("PRE", "I"), p = "CO", correction_only = TRUE)
# when standard is 'data.frame'
df_st <- matrix(c("V", "IV", "III", "III", "II", "I", "PRE"), nrow = 2, ncol = 7, byrow = TRUE)
df_st <- as.data.frame(df_st)
a <- ef_china(standard = df_st, p = "PM10", ta = rep(celsius(20), 2),
altitude = rep(1501, 2), speed = rep(Speed(29), 2), sulphur = rep(50, 2))
dim(a)
dim(df_st)
ef_china(standard = df_st, p = "PM2.5", ta = rep(celsius(20), 2),
altitude = rep(1501, 2), speed = rep(Speed(29), 2), sulphur = rep(50, 2))
a
# when standard, temperature and humidity are data.frames
# assuming 10 regions
df_st <- matrix(c("V", "IV", "III", "III", "II", "I", "PRE"), nrow = 10, ncol = 7, byrow = TRUE)
df_st <- as.data.frame(df_st)
df_t <- matrix(21:30, nrow = 10, ncol = 12, byrow = TRUE)
df_t <- as.data.frame(df_t)
for(i in 1:12) df_t[, i] <- celsius(df_t[, i])
# assuming 10 regions
df_h <- matrix(seq(0.4, 0.5, 0.05), nrow = 10, ncol = 12, byrow = TRUE)
df_h <- as.data.frame(df_h)
a <- ef_china(standard = df_st, p = "CO", ta = df_t, humidity = df_h,
altitude = rep(1501, 10), speed = rep(Speed(29), 10), sulphur = rep(50, 10))
a
a <- ef_china(standard = df_st, p = "PM2.5", ta = df_t, humidity = df_h,
altitude = rep(1501, 10), speed = rep(Speed(29), 10), sulphur = rep(50, 10))
a
a <- ef_china(standard = df_st, p = "PM10", ta = df_t, humidity = df_h,
altitude = rep(1501, 10), speed = rep(Speed(29), 10), sulphur = rep(50, 10))
a
dim(a)
}
}
\seealso{
\code{\link{ef_ldv_speed}} \code{\link{emis_hot_td}}
}
\keyword{China}
\keyword{ef_china}
\keyword{emission}
\keyword{factors}
