% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw.R
\name{aw}
\alias{aw}
\title{Average Weight from hourly traffic data.}
\usage{
aw(
  pc,
  lcv,
  hgv,
  bus,
  mc,
  p_pc,
  p_lcv,
  p_hgv,
  p_bus,
  p_mc,
  w_pc = 1,
  w_lcv = 3.5,
  w_hgv = 20,
  w_bus = 20,
  w_mc = 0.5,
  net
)
}
\arguments{
\item{pc}{numeric vector for passenger cars}

\item{lcv}{numeric vector for light commercial vehicles}

\item{hgv}{numeric vector for heavy good vehicles or trucks}

\item{bus}{numeric vector for bus}

\item{mc}{numeric vector for motorcycles}

\item{p_pc}{data-frame profile for passenger cars, 24 hours only.}

\item{p_lcv}{data-frame profile for light commercial vehicles, 24 hours only.}

\item{p_hgv}{data-frame profile for heavy good vehicles or trucks, 24 hours only.}

\item{p_bus}{data-frame profile for bus, 24 hours only.}

\item{p_mc}{data-frame profile for motorcycles, 24 hours only.}

\item{w_pc}{Numeric, factor equivalence}

\item{w_lcv}{Numeric, factor equivalence}

\item{w_hgv}{Numeric, factor equivalence}

\item{w_bus}{Numeric, factor equivalence}

\item{w_mc}{Numeric, factor equivalence}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}
}
\value{
data.frame with with average weight
}
\description{
\code{\link{aw}} average weight form traffic.
}
\examples{
\dontrun{
data(net)
data(pc_profile)
p1 <- pc_profile[, 1]
aw1 <- aw(pc = net$ldv*0.75,
            lcv = net$ldv*0.1,
            hgv = net$hdv,
            bus = net$hdv*0.1,
            mc = net$ldv*0.15,
            p_pc = p1,
            p_lcv = p1,
            p_hgv = p1,
            p_bus = p1,
            p_mc = p1)
head(aw1)
}
}
