% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-docker.R
\name{vetiver_write_docker}
\alias{vetiver_write_docker}
\title{Write a Dockerfile for a vetiver model}
\usage{
vetiver_write_docker(vetiver_model, plumber_file = "plumber.R", path = ".")
}
\arguments{
\item{vetiver_model}{A deployable \code{\link[=vetiver_model]{vetiver_model()}} object}

\item{plumber_file}{A path for your Plumber file, created via
\code{\link[=vetiver_write_plumber]{vetiver_write_plumber()}}. Defaults to \code{plumber.R} in the working directory.}

\item{path}{A path to write the Dockerfile and \code{renv.lock} lockfile,
capturing the model's package dependencies. Defaults to the working directory.}
}
\value{
The content of the Dockerfile, invisibly.
}
\description{
After creating a Plumber file with \code{\link[=vetiver_write_plumber]{vetiver_write_plumber()}}, use
\code{vetiver_write_docker()} to create a Dockerfile plus an \code{renv.lock} file
for a pinned \code{\link[=vetiver_model]{vetiver_model()}}.
}
\examples{
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(pins)
tmp_plumber <- tempfile()
b <- board_temp(versioned = TRUE)
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)
vetiver_write_plumber(b, "cars_linear", file = tmp_plumber)
vetiver_write_docker(v, tmp_plumber, tempdir())
\dontshow{\}) # examplesIf}
}
