% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_predictiveness_update.R
\name{cv_predictiveness_update}
\alias{cv_predictiveness_update}
\title{Estimate the influence function for an estimator of predictiveness}
\usage{
cv_predictiveness_update(
  fitted_values,
  y,
  folds,
  weights = rep(1, length(y)),
  type = "r_squared",
  na.rm = FALSE
)
}
\arguments{
\item{fitted_values}{fitted values from a regression function; a list of length V, where each object is a set of predictions on the validation data.}

\item{y}{the outcome.}

\item{folds}{the cross-validation folds}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which risk parameter are you estimating (defaults to \code{r_squared}, for the $R^2$)?}

\item{na.rm}{logical; should NAs be removed in computation? (defaults to \code{FALSE})}
}
\value{
The estimated influence function values for the given measure of predictiveness.
}
\description{
Estimate the influence function for the given measure of predictiveness.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
