% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixParametersTypes.R
\name{fixParametersTypes}
\alias{fixParametersTypes}
\title{Fix data types in a parameters dataframe.}
\usage{
fixParametersTypes(x)
}
\arguments{
\item{x}{dataframe resulting from \code{\link{parametersDataframe}}.}
}
\value{
Same dataframe provided in argument \code{x} but with fixed data types.
}
\description{
It converts all columns (but the \code{label} one) of a parameters dataframe created by \code{\link{parametersDataframe}} and filled by the user into type numeric, and checks the coherence of the parameters for each taxon. It provides feedback on the check results on screen for each taxon.
}
\examples{

parameters <- parametersDataframe(rows=1)
parameters[1,] <- c("Species 1", 50, 20, 2, 0.2, 0, 100, 1000, 1, 0, 50, 10, 0, 0, 600, 600)
parameters <- fixParametersTypes(x=parameters)

}
\seealso{
\code{\link{parametersDataframe}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
