% Generated by roxygen2 (4.0.2): do not edit by hand
\name{generateSpFromPCA}
\alias{generateSpFromPCA}
\title{Generate a virtual species distribution with a PCA of environmental variables}
\usage{
generateSpFromPCA(raster.stack, rescale = TRUE, niche.breadth = "any",
  means = NULL, sds = NULL, pca = NULL, remove.collinearity = FALSE,
  multicollinearity.cutoff = 0.7, sample.points = FALSE,
  nb.points = 10000, plot = TRUE)
}
\arguments{
\item{raster.stack}{a RasterStack object, in which each layer represent an environmental
variable.}

\item{rescale}{\code{TRUE} of \code{FALSE}. Should the output suitability raster be
rescaled between 0 and 1?}

\item{niche.breadth}{\code{"any"}, \code{"narrow"} or \code{"wide"}. This parameter
defines how tolerant is the species regarding environmental conditions by adjusting
the standard deviations of the gaussian functions. See details.}

\item{means}{a vector containing two numeric values. Will be used to define
the means of the gaussian response functions to the axes of the PCA.}

\item{sds}{a vector containing two numeric values. Will be used to define
the standard deviations of the gaussian response functions to the axes of
the PCA.}

\item{pca}{a \code{dudi.pca} object. You can provide a pca object that you
computed yourself with \code{\link[ade4]{dudi.pca}}}

\item{remove.collinearity}{\code{TRUE} of \code{FALSE}. Can be set to \code{TRUE}
to remove groups of collinear variables (at the cutoff \code{multicollinearity.cutoff})
in your dataset: only one variable per group will be kept. See \code{\link{removeCollinearity}}
for details.}

\item{multicollinearity.cutoff}{a numeric value between 0 and 1. Only useful if
\code{remove.collinearity = TRUE}. The cutoff of collinearity above which
variables will be grouped together.}

\item{sample.points}{\code{TRUE} of \code{FALSE}. If you have a large
raster file then use this parameter to sample a number of points equal to
\code{nb.points}.}

\item{nb.points}{a numeric value. Only useful if \code{sample.points = TRUE}.
The number of sampled points from the raster, to perform the PCA. A too small
value may not be representative of the environmental conditions in your raster.}

\item{plot}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, the generated virtual species will be plotted.}
}
\value{
a \code{list} with 3 elements:
\itemize{
\item{\code{approach}: the approach used to generate the species, \emph{i.e.}, \code{"pca"}}
\item{\code{details}: the details and parameters used to generate the species}
\item{\code{suitab.raster}: the virtual species distribution, as a Raster object containing the
environmental suitability}
}
The structure of the virtualspecies object can be seen using str()
}
\description{
This functions generates a virtual species distribution by computing a
PCA among environmental variables, and simulating the response of the species
along the two first axes of the PCA. The response to axes of the PCA is
determined with gaussian functions.
}
\details{
This function proceeds in 3 steps:
\enumerate{
\item{A PCA of environmental conditions is generated}
\item{Gaussian responses to the first two axes are computed}
\item{These responses are multiplied to obtain the final environmental suitability}}

The shape of gaussian responses can be determined manually, by defining both
\code{means} and \code{sds}, or randomly. The random generation is constrained
by the argument \code{niche.breadth}, which controls the range of possible
standard deviation values. This range of values is based on
a fraction of the axis:
\itemize{
\item{\code{"any"}: the standard deviations can have values from 1/100 to 1/2
of the axes' span}
\item{\code{"narrow"}: the standard deviations can have values from 1/100 to 1/10
of the axes' span}
\item{\code{"wide"}: the standard deviations can have values from 1/10 to 1/2
of the axes' span}
}
}
\note{
To perform the PCA, the function has to transform the raster into a matrix.
This may not be feasible if the raster is too large for the computer's memory.
In this case, you should perform the PCA on a sample of your raster with
set \code{sample.points = TRUE} and choose the number of points to sample with
\code{nb.points}.
}
\examples{
# Create an example stack with four environmental variables
a <- matrix(rep(dnorm(1:100, 50, sd = 25)),
            nrow = 100, ncol = 100, byrow = TRUE)
env <- stack(raster(a * dnorm(1:100, 50, sd = 25)),
             raster(a * 1:100),
             raster(a * logisticFun(1:100, alpha = 10, beta = 70)),
             raster(t(a)))
names(env) <- c("var1", "var2", "var3", "var4")
plot(env) # Illustration of the variables





# Generating a species with the PCA

generateSpFromPCA(raster.stack = env)

# The top part of the plot shows the PCA and the response functions along
# the two axes.
# The bottom part shows the probabilities of occurrence of the virtual
# species.





# Defining manually the response to axes

generateSpFromPCA(raster.stack = env,
           means = c(-2, 0),
           sds = c(0.6, 1.5))

# This species can be seen as occupying intermediate altitude ranges of a
# conic mountain.
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

with help from C. N. Meynard, C. Bellard & F. Courchamp
}
\seealso{
\code{\link{generateSpFromFun}} to generate a virtual species with
the responses to each environmental variables.
#'
}

