% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResponse.R
\name{plotResponse}
\alias{plotResponse}
\title{Visualise the response of the virtual species to environmental variables}
\usage{
plotResponse(x, parameters = NULL, approach = NULL, rescale = TRUE,
  axes.to.plot = NULL, no.plot.reset = FALSE, ...)
}
\arguments{
\item{x}{the output from \code{\link{generateSpFromFun}}, \code{\link{generateSpFromPCA}}, 
\code{\link{generateRandomSp}}, or
a raster layer/stack of environmental variables (see details for the latter).}

\item{parameters}{in case of manually defined response functions, a list 
containing the associated parameters. See details.}

\item{approach}{in case of manually defined response functions, the chosen
approach: either \code{"response"} for a per-variable response approach, or
\code{"pca"} for a PCA approach.}

\item{rescale}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, individual response
plots are rescaled between 0 and 1.}

\item{axes.to.plot}{a vector of 2 values listing the two axes of the PCA to plot.
Only useful for a PCA species.}

\item{no.plot.reset}{\code{TRUE} or \code{FALSE}. If \code{FALSE}, the plot window
will be reset to its initial state after the response has been plotted.}

\item{...}{further arguments to be passed to \code{plot}. See 
\code{\link[graphics]{plot}} and \code{\link[graphics]{par}}.}
}
\description{
This function plots the relationships between the virtual species and the environmental variables.
It requires either the output from \code{\link{generateSpFromFun}}, \code{\link{generateSpFromPCA}}, 
\code{\link{generateRandomSp}},
or a manually defined set of environmental variables and response functions.
}
\details{
If you provide the output from \code{\link{generateSpFromFun}}, \code{\link{generateSpFromPCA}} or
\code{\link{generateRandomSp}}
then the function will automatically make the appropriate plots.

Otherwise, you can provide a raster layer/stack of environmental variables to
 \code{x} and a list of functions to \code{parameters} to perform the plot.
In that case, you have to specify the \code{approach}: \code{"reponse"} or
\code{"PCA"}:
\itemize{
\item{if \code{approach = "response"}: Provide to \code{parameters} a 
\code{list} exactly as defined in \code{\link{generateSpFromFun}}:\cr
\code{list(
           var1 = list(fun = 'fun1', args = list(arg1 = ..., arg2 = ..., etc.)),
           var2 = list(fun = 'fun2', args = list(arg1 = ..., arg2 = ..., etc.)))}\cr

}
\item{if \code{approach = "PCA"}: Provide to \code{parameters} a
\code{list} containing the following elements:
\itemize{
\item{\code{pca}: a \code{dudi.pca} object computed  with 
\code{\link[ade4]{dudi.pca}}}
\item{\code{means}: a vector containing two numeric values. Will be used to define
the means of the gaussian response functions to the axes of the PCA.}
\item{\code{sds} a vector containing two numeric values. Will be used to define
the standard deviations of the gaussian response functions to the axes of 
the PCA.}}
}
}
}
\examples{
# Create an example stack with four environmental variables
a <- matrix(rep(dnorm(1:100, 50, sd = 25)), 
            nrow = 100, ncol = 100, byrow = TRUE)
env <- stack(raster(a * dnorm(1:100, 50, sd = 25)),
             raster(a * 1:100),
             raster(a * logisticFun(1:100, alpha = 10, beta = 70)),
             raster(t(a)))
names(env) <- c("var1", "var2", "var3", "var4")

# Per-variable response approach:
parameters <- formatFunctions(var1 = c(fun = 'dnorm', mean = 0.00012,
                                       sd = 0.0001),
                              var2 = c(fun = 'linearFun', a = 1, b = 0),
                              var3 = c(fun = 'quadraticFun', a = -20, b = 0.2, 
                                       c = 0),
                              var4 = c(fun = 'logisticFun', alpha = -0.001, 
                                       beta = 0.002))
sp1 <- generateSpFromFun(env, parameters, plot = TRUE)
plotResponse(sp1)

# PCA approach:
sp2 <- generateSpFromPCA(env, plot = FALSE)
par(mfrow = c(1, 1))
plotResponse(sp2)

}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

with help from C. N. Meynard, C. Bellard & F. Courchamp
}
