% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visUpdateEdges.R
\name{visUpdateEdges}
\alias{visUpdateEdges}
\title{Function to update the information of edges, with shiny only.}
\usage{
visUpdateEdges(graph, edges, legend = FALSE)
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{edges}{: data.frame with the information of edges. See \link{visEdges}
\itemize{
 \item{"id"}{ : edge id, for update}
 \item{"from"}{ : node id, begin of the edge}
 \item{"to"}{ : node id, end of the edge}
 \item{"label"}{ : label}
 \item{"value"}{ : size}
 \item{"title"}{ : tooltip}
 \item{...}{}
}}

\item{legend}{: Boolean. Update edges on legend ? Default to FALSE}
}
\description{
Function to update the information of edges, with shiny only. You can also use this function passing new edges.
The link is based on id.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
