% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visOmopTable.R
\name{formatTable}
\alias{formatTable}
\title{Format a summarised_result object into a gt, flextable or tibble object}
\usage{
formatTable(
  result,
  formatEstimateName,
  header,
  split,
  groupColumn = NULL,
  type = "gt",
  renameColumns = NULL,
  minCellCount = lifecycle::deprecated(),
  excludeColumns = c("result_id", "estimate_type"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result.}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{header}{A vector containing which elements should go into the header
in order (\code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, and \code{settings}).}

\item{split}{A vector containing the name-level groups to split ("group",
"strata", "additional"), or an empty character vector to not split.}

\item{groupColumn}{Columns to use as group labels. By default the name of the
new group will be the column names separated by "_". To specify a new
grouping name enter a named list such as:
list(\code{newGroupName} = c("variable_name", "variable_level"))}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{renameColumns}{Named vector to customise column names, for instance:
c("Database name" = "cdm_name")). By default column names are transformed to
sentence case.}

\item{minCellCount}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Suppression of
estimates when counts < minCellCount should be done before with
\code{ompogenerics::suppress()}.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsVisOmopTable() shows allowed arguments and
their default values.}
}
\value{
A tibble, gt, or flextable object.
}
\description{
\code{formatTable()} was renamed to \code{visOmopTable()}
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
mockSummarisedResult() |> formatTable(
  formatEstimateName = c("N\%" = "<count> (<percentage>)",
                         "N" = "<count>",
                         "Mean (SD)" = "<mean> (<sd>)"),
  header = c("group"),
  split = c("group","strata",  "additional")
)

}
\keyword{internal}
