% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{vtSimu}
\alias{vtSimu}
\title{Conduct simulation study}
\usage{
vtSimu(n.rep = 100, seed = NULL, ..., n.cores = 1,
  update.progress = NULL)
}
\arguments{
\item{n.rep}{Number of repetitions}

\item{seed}{Seed}

\item{...}{Optional parameters for \code{\link{vtSingleTrial}}}

\item{n.cores}{Number of cores for parallel computations}

\item{update.progress}{Reserved parameter for Shiny GUI}
}
\value{
A class \code{VTSIMU} list with length \code{n.rep} of results. Each item is
    a list return from \code{\link{vtSingleTrial}}.
}
\description{
Simulate clinical trials with given settings for multiple times to evaluate
the study operating characteristics.
}
\examples{

rst.sce <- vtScenario(tox = c(0.05, 0.05, 0.08),
                      res = c(0.2, 0.3, 0.5),
                      rho = 1)

rst.simu  <- vtSimu(n.rep = 100, n.cors = 2, trueps = rst.sce,
                    size.cohort=3, size.level=12, prob.mdl="NONPARA");


}
