% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_events.R
\name{plot_events}
\alias{plot_events}
\title{Plot the events of a data frame}
\usage{
plot_events(data_orig, showLabels, background_lines)
}
\arguments{
\item{data_orig}{the data frame to be plotted (ranges + events)}

\item{showLabels}{boolean, show labels on events or not}

\item{background_lines}{number of grey background lines to draw}
}
\value{
a list containing the plots for the groups in data
}
\description{
Plot the events of a data frame
}
\examples{
\dontrun{
plot_events(data.frame(event = 1:2, start = as.POSIXct(c(Sys.Date(), Sys.Date() + 10)),
                       end = as.POSIXct(c(Sys.Date(), Sys.Date() + 10)),
                       group = "", tooltip = "", col = "green", fontcol = "black",
                       subplot = 1, y = 1:2, labelPos = "center", label = 1:2),
            showLabels = TRUE, background_lines = 11)
}
}
