% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{racusum_arl_h_sim}
\alias{racusum_arl_h_sim}
\title{Compute alarm threshold of RA-CUSUM control charts using simulation}
\usage{
racusum_arl_h_sim(L0, df, coeff, R0 = 1, RA = 2, m = 100, yemp = TRUE,
  nc = 1, verbose = FALSE)
}
\arguments{
\item{L0}{double. Prespecified in-control Average Run Length.}

\item{df}{DataFrame. First column are Parsonnet Score values within a range of zero to 100 representing
the preoperative patient risk. The second column are binary (0/1) outcome values of each operation.}

\item{coeff}{NumericVector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model.}

\item{R0}{double. Odds ratio of death under the null hypotheses.}

\item{RA}{double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio RA=2. Detecting
improvement in performance with decreased mortality risk by halving the odds ratio of death
RA=1/2.}

\item{m}{integer. Number of simulation runs.}

\item{yemp}{boolean. If TRUE, use emirical outcome values, else use model.}

\item{nc}{integer. Number of cores used for parallel processing.}

\item{verbose}{boolean. If TRUE verbose output is included, if FALSE a quiet calculation of h is done.}
}
\value{
Returns a single value which is the control limit h for a given in-control ARL.
}
\description{
Compute alarm threshold of RA-CUSUM control charts using simulation.
}
\details{
The function \code{racusum_arl_h_sim} determines the control limit for given in-control ARL (L0) by applying a
multi-stage search procedure which includes secant rule and the parallel version of \code{\link{racusum_arl_sim}}
using \code{\link{mclapply}}.
}
\examples{
\dontrun{
library("vlad")
library("spcadjust")
data("cardiacsurgery")
cardiacsurgery <- dplyr::mutate(cardiacsurgery, phase=factor(ifelse(date < 2*365, "I", "II")))
S2 <- subset(cardiacsurgery, c(surgeon==2), c("phase", "Parsonnet", "status"))
# subset phase I (In-control) of surgeons 2
S2I <- subset(S2, c(phase=="I"), c("Parsonnet", "status"))
# estimate coefficients from logit model
coeff1 <- round(coef(glm(status~Parsonnet, data=S2I, family="binomial")), 3)

racusum_arl_h_sim(L0=740, df=S2I, coeff=coeff1, m=10^2, nc=4)
}
}
\author{
Philipp Wittenberg
}
