% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eocusum_sim.R
\name{eocusum_arl_h_sim}
\alias{eocusum_arl_h_sim}
\title{Compute alarm threshold of EO-CUSUM control charts using simulation}
\usage{
eocusum_arl_h_sim(L0, k, df, coeff, m = 100, yemp = TRUE,
  side = "low", nc = 1, jmax = 4, verbose = FALSE)
}
\arguments{
\item{L0}{Double. Prespecified in-control Average Run Length.}

\item{k}{Double. Reference value of the CUSUM control chart. Either \code{0} or a positive
value. Can be determined with function \code{\link{optimal_k}}.}

\item{df}{Data Frame. First column are Parsonnet Score values within a range of \code{0} to
\code{100} representing the preoperative patient risk. The second column are binary (0/1)
outcome values of each operation.}

\item{coeff}{Numeric Vector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model. For more information see details.}

\item{m}{Integer. Number of simulation runs.}

\item{yemp}{Logical. If \code{TRUE} use observed outcome value, if \code{FALSE} use estimated
binary logistc regression model.}

\item{side}{Character. Default is \code{"low"} to calculate ARL for the upper arm of the V-mask.
If side = \code{"up"}, calculate the lower arm of the V-mask.}

\item{nc}{Integer. Number of cores.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{verbose}{Logical. If \code{TRUE} verbose output is included, if \code{FALSE} a quiet
calculation of \code{h} is done.}
}
\value{
Returns a single value which is the control limit \code{h} for a given ARL.
}
\description{
Compute alarm threshold of EO-CUSUM control charts using simulation.
}
\details{
The function \code{eocusum_arl_h_sim} determines the control limit for given in-control
 ARL (\code{L0}) by applying a multi-stage search procedure which includes secant rule and the
  parallel version of \code{\link{eocusum_arl_sim}} using \code{\link{mclapply}}.
}
\examples{
\donttest{

# This function is deprecated. See eocusum_crit_sim() instead.

 }
}
\author{
Philipp Wittenberg
}
