% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmr-methods.R
\name{vmrUpdateEnvVersion}
\alias{vmrUpdateEnvVersion}
\title{Update a \strong{vmr} environment.}
\usage{
vmrUpdateEnvVersion(vmr)
}
\arguments{
\item{vmr}{a \strong{vmr} object}
}
\value{
a \strong{vmr} object
}
\description{
Force to use the latest box version of the current \strong{vmr} environment.
}
\details{
Put \strong{vmr} object version to latest and update the Vagrant File template.
Download the new box version if needed.
}
\examples{
\dontrun{
boxes <- vmrList()
vmr <- vmrCreate(boxes$Name[1], version = "oldone")
vmr <- vmrInitEnv(vmr)

# update to latest
vmr <- vmrUpdateEnvVersion(vmr)
vmrStart()
}
}
