% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_coords.R
\name{polar_coords}
\alias{polar_coords}
\title{Coordinates for Three Way Polar Plot}
\usage{
polar_coords(
  sampledata,
  contrast,
  pvalues,
  expression,
  groups = NULL,
  p_col_suffix = "pvalues",
  padj_col_suffix = "padj",
  fc_col_suffix = NULL,
  padjust_method = "BH",
  multi_group_prefix = NULL,
  non_sig_name = "Not Significant",
  significance_cutoff = 0.01,
  fc_cutoff = 0.3,
  label_column = NULL,
  cutoff_criteria = "pvalue"
)
}
\arguments{
\item{sampledata}{A data frame containing the sample information.
This must contain: an ID column containing the sample IDs which can be 
matched to the `expression` data and a 
contrast column containing the three-level factor used for contrasts.}

\item{contrast}{The column name in `sampledata` which contains the 
three-level factor used for contrast.}

\item{pvalues}{A data frame containing: \itemize{
\item three `p_col_suffix` columns: one for 
the pvalue for each comparison between groups;
\item three optional `fc_col_suffix` columns for the fold change between 
each comparison (if NULL, no Fold Change columns are included); 
\item three optional `padj_col_suffix` columns (if NULL 
adjusted p values are calculated using `padjust_method`); 
\item and optional 'p', 
'padj and 'fc' columns for a three-way test, such as ANOVA or likelihood 
ratio test, defined by `multi_group_prefix`. 
}}

\item{expression}{An optional data frame containing expression data for
downstream analysis and visualisation. The rows must contain probes which
match the rows in pvalues and the columns must contain samples which match
\code{sampledata$ID}.}

\item{groups}{The groups to be compared (if NULL this defaults
to \code{levels(sampledata[, 'contrasts'])}).}

\item{p_col_suffix}{The suffix word to define columns containing p values
(default = 'pvalues'). These must not contain underscores;}

\item{padj_col_suffix}{The suffix word to define columns containing adjusted
p values (default = 'padj').  These must not contain underscores. 
If NULL these will be calculated using \code{padjust_method}}

\item{fc_col_suffix}{The optional suffix word to define columns containing 
log fold change values (default = 'logFC'). These must not contain 
underscores.}

\item{padjust_method}{The method used to calculate adjusted p values if 
padj_col_suffix is NULL (default = 'BH'). See \code{\link[stats]{p.adjust}}. 
If NULL no adjusted pvalue is calculated.}

\item{multi_group_prefix}{Optional column prefix for statistics (p, padj, 
and fold change) across all three groups (typically ANOVA or likelihood 
ratio tests). default = NULL. These must not contain underscores}

\item{non_sig_name}{Category name to assign to non-significant points}

\item{significance_cutoff}{Value defining the significance cut-off (points 
with pvalues below this point will be classed as \code{non_sig_name})}

\item{fc_cutoff}{The cut-off for fold change, below which markers will be
classed as \code{non_sig_name}` (default = 0.3).}

\item{label_column}{Optional column name in pvalues for markers to be 
labelled with at plotting stage. If NULL the rownames of pvalues are used.}

\item{cutoff_criteria}{Whether to use pvalue or padj for the colour coding 
significance cutoff.}
}
\value{
Returns an S4 polar object containing:
\itemize{
  \item{'polar'} A data.frame containing:
  \itemize{
      \item{The mean expression for each of the three groups in comparison}
      \item{The z-score polar coordinates: 'y_zscore', 'x_zscore' and 
      'r_zscore'}
      \item{The fold-change polar coordinates: 'y_fc', 'x_fc' and 'r_fc'}
      \item{'angle': The angle in radians for polar coordinates}
      \item{'angle_degrees': The angle in degrees}
      \item{'max_exp': The maximally expressed group}
      \item{'sig': The significance group}
  }
  \item{'pvalues'} A data frame containing the p-values, adjusted p-values,
  and optional log(fold changes) for all three comparisons between groups in 
  the contrast factor, as well as optional multi-group tests.
  \item{'sampledata'} Sample data with column ID and contrast
  \item{'contrast'} The column name in `sampledata`` which contains the
  three-group contrast factor used for comparisons.
  \item{'multi_group_test'} Column name prefix for statistical tests between
  all three groups
  \item{'expression'} An optional data frame or matrix containing the
  expression data
  \item{'non_sig_name'} The category name for variables which are classed as 
  not significant
}
}
\description{
This function creates a polar object of S4 class for downstream plots 
containing the p-values from a three-way group comparison, expression data 
sample data and polar coordinates.
}
\examples{
data(example_data)
syn_polar <- polar_coords(sampledata=syn_example_meta,
                    contrast="Pathotype",
                    groups = NULL,
                    pvalues = syn_example_p,
                    expression = syn_example_rld,
                    p_col_suffix = "pvalue",
                    padj_col_suffix = "padj",
                    fc_col_suffix = NULL,
                    padjust_method = "BH",
                    multi_group_prefix = NULL,
                    non_sig_name = "Not Significant",
                    significance_cutoff = 0.01, 
                    fc_cutoff=0.3, 
                    label_column = NULL)
table(syn_polar@polar$sig) 
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://www.cell.com/cell-reports/fulltext/S2211-1247(19)31007-1}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\keyword{dplot}
\keyword{spatial}
