% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_trio.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Creates a single volcano plot}
\usage{
volcano_plot(
  pvalues_df,
  comparison,
  p_cutoff = 0.05,
  fc_cutoff = 1,
  label_rows = NULL,
  p_col_suffix = "pvalue",
  padj_col_suffix = "padj",
  fc_col_suffix = "logFC",
  cutoff_criteria = "pvalue",
  label_col = "label",
  label_size = 3,
  text_size = 10,
  marker_alpha = 0.7,
  marker_size = 3,
  marker_outline_colour = "white",
  marker_outline_width = 0.5,
  sig_names = NULL,
  colour_col = FALSE,
  colours = c("salmon", "steelblue", "limegreen", "grey60"),
  drop_unused_cols = TRUE,
  fc_line = TRUE,
  p_line = TRUE,
  line_colours = c("black", "black")
)
}
\arguments{
\item{pvalues_df}{The pvalues data frame. This must contain a pvalue, padj,
and logFC column as well as a label column.}

\item{comparison}{The comparison (column_prefix) to use.}

\item{p_cutoff}{The cut-off for adjusted pvalue significance (default = 
0.05).}

\item{fc_cutoff}{The cut-off for fold change significance (default = 1).}

\item{label_rows}{Row numbers or names of values to be annotated/labelled
(default = NULL).}

\item{p_col_suffix}{The suffix word to define columns containing p values
(default = 'pvalues').}

\item{padj_col_suffix}{The suffix word to define columns containing adjusted
p values (default = 'padj'). If NULL these will be calculated using
\code{padjust_method}.}

\item{fc_col_suffix}{The optional suffix word to define columns containing
log fold change values (default = 'logFC').}

\item{cutoff_criteria}{Whether to use pvalue or padj for the colour coding 
significance cutoff.}

\item{label_col}{Optional column name in 'pvalues_df' for labelling markers.
If NULL the rownames of pvalues are used.}

\item{label_size}{The font size of labels (default = 3)}

\item{text_size}{The font size of text (default = 10)}

\item{marker_alpha}{The alpha parameter for markers (default = 0.7).}

\item{marker_size}{The size of markers (default = 3)}

\item{marker_outline_colour}{Colour for marker outline (default = white)}

\item{marker_outline_width}{Width for marker outline (default = 0.5)}

\item{sig_names}{A character vector of labels to be used for:
non-significant; adjusted p < p_cutoff; |Fold Change| > fc_cutoff; and
finally adjusted p < p_cutoff.
If NULL c('Not Significant', \code{paste('Padj <', p_cutoff)},
\code{paste('|FC| >', fc_cutoff)},
\code{paste('Padj <', p_cutoff, 'and |FC| >', fc_cutoff)}) is used.}

\item{colour_col}{Logical whether colour coding has been passed in 
through `pvalues_df$col`.}

\item{colours}{A character vector of colours to be used. This can be of 
length 3, 4, 7 or 8 depending on the colour coding desired. 
   \itemize{
      \item If length is 3, c(a,b,c): Only the significant wings are 
      highlighted (where p>p_cutoff and abs(fc)>fc_cutoff) on the graph: 
      \itemize{
      \item a: padj <= p_cutoff & fc <= -1*fc_cutoff
     \item b: padj <= p_cutoff & fc >= fc_cutoff
      \item c: padj >  p_cutoff | abs(fc) < fc_cutoff
      }
      \item If length is 4, c(a,b,c,d): 
      \itemize{
      \item a: padj <= p_cutoff & abs(fc) >= fc_cutoff
      \item b: padj <= p_cutoff & abs(fc) < fc_cutoff
      \item c: padj > p_cutoff & abs(fc) >= fc_cutoff
      \item d: padj < p_cutoff & abs(fc) < fc_cutoff
      }
      \item If length is 8 c(a,b,c,d,e,f,g,h): Each significance group is 
      colour-coded
      \itemize{
      \item a: padj <= p_cutoff & fc <= -1*fc_cutoff
      \item b: padj <=  p_cutoff & -1*fc_cutoff < fc <= 0
      \item c: padj <=  p_cutoff & 0 < fc < fc_cutoff
      \item d: padj <= p_cutoff & fc >= fc_cutoff
      \item e: padj > p_cutoff & fc <= -1*fc_cutoff
      \item f: padj >  p_cutoff & -1*fc_cutoff < fc <= 0
      \item g: padj >  p_cutoff & 0 < fc < fc_cutoff
      \item h: padj > p_cutoff & fc >= fc_cutoff
      }
  }}

\item{drop_unused_cols}{Logical whether to drop colours not used from legend 
(default=T).}

\item{fc_line}{Logical whether to add vertical dashed line at fc_cutoff
(default = TRUE).}

\item{p_line}{Logical whether to add horizontal dashed line at p_cutoff
(default = TRUE).}

\item{line_colours}{A character vector stating the colour of lines to be
used for fc_line and p_line respectively (default = c('black', 'black')).}
}
\value{
Returns a single volcano plot.
}
\description{
This function creates a volcano plot for one comparison group
}
\examples{
data("example_data")
volcano_plot(syn_example_p,
             "Fibroid_Lymphoid",
             label_col = "Gene",
             label_rows=c("SLAMF6"),
             fc_col_suffix="log2FoldChange")
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://www.cell.com/cell-reports/fulltext/S2211-1247(19)31007-1}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\concept{volcanoplot}
\keyword{hplot}
