% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenCross.R
\name{GenCross}
\alias{GenCross}
\title{Generator function for cross polytopes}
\usage{
GenCross(dimension, repr)
}
\arguments{
\item{dimension}{The dimension of the cross polytope.}

\item{repr}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation.}
}
\value{
A polytope class representing a cross polytope in H- or V-representation.
}
\description{
This function can be used to generate the \eqn{d}-dimensional cross polytope in H- or V-representation.
}
\examples{
# generate a 10-dimensional cross polytope in H-representation
P = GenCross(10, 'H')

# generate a 15-dimension cross polytope in V-representation
P = GenCross(15, 'V')
}
