% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_lines.R
\name{vroom_lines}
\alias{vroom_lines}
\title{Read lines from a file}
\usage{
vroom_lines(
  file,
  n_max = Inf,
  skip = 0,
  altrep = TRUE,
  altrep_opts = deprecated(),
  num_threads = vroom_threads(),
  progress = vroom_progress()
)
}
\arguments{
\item{file}{path to a local file.}

\item{n_max}{Maximum number of records to read.}

\item{skip}{Number of lines to skip before reading data.}

\item{altrep}{Control which column types use Altrep representations,
either a character vector of types, \code{TRUE} or \code{FALSE}. See
\code{\link[=vroom_altrep]{vroom_altrep()}} for for full details.}

\item{altrep_opts}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}

\item{num_threads}{Number of threads to use when reading and materializing
vectors. If your data contains embedded newlines (newlines within fields)
you \emph{must} use \code{num_threads = 1} to read the data properly.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}
}
\description{
\code{vroom_lines()} is similar to \code{readLines()}, however it reads the lines
lazily like \code{\link[=vroom]{vroom()}}, so operations like \code{length()}, \code{head()}, \code{tail()} and \code{sample()}
can be done much more efficiently without reading all the data into R.
}
\examples{
lines <- vroom_lines(vroom_example("mtcars.csv"))

length(lines)
head(lines, n = 2)
tail(lines, n = 2)
sample(lines, size = 2)
}
