% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance.R
\name{value_variables_C}
\alias{value_variables_C}
\title{Value variables for prediction a categorical outcome.}
\usage{
value_variables_C(dframe, varlist, outcomename, outcometarget, ...,
  weights = c(), minFraction = 0.02, smFactor = 0, rareCount = 0,
  rareSig = 1, collarProb = 0, scale = FALSE, doCollar = FALSE,
  splitFunction = NULL, ncross = 3, forceSplit = FALSE,
  catScaling = FALSE, verbose = FALSE, parallelCluster = NULL,
  use_parallel = TRUE)
}
\arguments{
\item{dframe}{Data frame to learn treatments from (training data), must have at least 1 row.}

\item{varlist}{Names of columns to treat (effective variables).}

\item{outcomename}{Name of column holding outcome variable. dframe[[outcomename]] must be only finite non-missing values.}

\item{outcometarget}{Value/level of outcome to be considered "success",  and there must be a cut such that dframe[[outcomename]]==outcometarget at least twice and dframe[[outcomename]]!=outcometarget at least twice.}

\item{...}{no additional arguments, declared to forced named binding of later arguments}

\item{weights}{optional training weights for each row}

\item{minFraction}{optional minimum frequency a categorical level must have to be converted to an indicator column.}

\item{smFactor}{optional smoothing factor for impact coding models.}

\item{rareCount}{optional integer, allow levels with this count or below to be pooled into a shared rare-level.  Defaults to 0 or off.}

\item{rareSig}{optional numeric, suppress levels from pooling at this significance value greater.  Defaults to NULL or off.}

\item{collarProb}{what fraction of the data (pseudo-probability) to collar data at if doCollar is set during \code{\link{prepare.treatmentplan}}.}

\item{scale}{optional if TRUE replace numeric variables with regression ("move to outcome-scale").}

\item{doCollar}{optional if TRUE collar numeric variables by cutting off after a tail-probability specified by collarProb during treatment design.}

\item{splitFunction}{(optional) see vtreat::buildEvalSets .}

\item{ncross}{optional scalar>=2 number of cross-validation rounds to design.}

\item{forceSplit}{logical, if TRUE force cross-validated significance calculations on all variables.}

\item{catScaling}{optional, if TRUE use glm() linkspace, if FALSE use lm() for scaling.}

\item{verbose}{if TRUE print progress.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}

\item{use_parallel}{logical, if TRUE use parallel methods.}
}
\value{
table of variable valuations
}
\description{
Value variables for prediction a categorical outcome.
}
