% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center_scale.R
\name{center_scale}
\alias{center_scale}
\title{Center and scale a set of variables.}
\usage{
center_scale(d, center, scale)
}
\arguments{
\item{d}{data.frame to work with}

\item{center}{named vector of variables to center}

\item{scale}{named vector of variables to scale}
}
\value{
d with centered and scaled columns altered
}
\description{
Center and scale a set of variables. Other columns are passed through.
}
\examples{

d <- data.frame(x = 1:5, 
                y = c('a', 'a', 'b', 'b', 'b'))
vars_to_transform = "x"
t <- base::scale(as.matrix(d[, vars_to_transform, drop = FALSE]), 
                 center = TRUE, scale = TRUE)
t

centering <- attr(t, "scaled:center")
scaling <- attr(t, "scaled:scale")
center_scale(d, center = centering, scale = scaling)

}
