% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/r_sample_ordered.R
\name{r_sample_ordered}
\alias{r_sample_ordered}
\title{Generate Random Ordered Factor Vector}
\usage{
r_sample_ordered(n, x = LETTERS[1:5], prob = NULL, name = "Ordered")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of elements.
}
\description{
Generate a random vector and coerces to an ordered factor.
}
\examples{
r_sample_ordered(100, name = "Var")

lvls <- c("Strongly Agree", "Agree", "Neutral", "Disagree", "Strongly Disagree")
table(r_sample_ordered(x = lvls, n=1000))

(out <- r_sample_ordered(x = c("Black", "Grey", "White"),
    prob = c(.5, .2, .3), n = 100))
slices <- c(table(out))
pie(slices, main="Pie Chart of Colors", col = tolower(names(slices)))
}
\seealso{
\code{\link[base]{sample}},
\code{\link[base]{ordered}}
}
\keyword{factor}
\keyword{ordered}

