% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race.R
\name{race}
\alias{race}
\title{Generate Random Vector of Races}
\usage{
race(n, x = c("White", "Hispanic", "Black", "Asian", "Bi-Racial", "Native",
  "Other", "Hawaiian"), prob = c(0.637, 0.163, 0.122, 0.047, 0.019, 0.007,
  0.002, 0.0015), name = "Race")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of elements.
}
\description{
Generate a random vector of races.
}
\details{
The races and probabilities used match approximate U.S. racial
make-up.  The default make up is:

\tabular{lr}{
  \bold{Race}     \tab \bold{Percent}\cr
  White     \tab 63.70 \%\cr
  Hispanic  \tab 16.30 \%\cr
  Black     \tab 12.20 \%\cr
  Asian     \tab 4.70 \%\cr
  Bi-Racial \tab 1.90 \%\cr
  Native    \tab .70 \%\cr
  Other     \tab .20 \%\cr
  Hawaiian  \tab .15 \%\cr
}
}
\examples{
race(10)
100*table(race(n <- 10000))/n
}
\seealso{
Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{likert}}, \code{\link{lorem_ipsum}},
  \code{\link{marital}}, \code{\link{military}},
  \code{\link{month}}, \code{\link{name}},
  \code{\link{normal}}, \code{\link{political}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{race}

