
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
rttestPSOptions <- R6::R6Class(
    "rttestPSOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pairs = NULL,
            tr = 0.2,
            md = FALSE,
            es = FALSE,
            ci = FALSE, ...) {

            super$initialize(
                package='walrus',
                name='rttestPS',
                requiresData=TRUE,
                ...)
        
            private$..pairs <- jmvcore::OptionPairs$new(
                "pairs",
                pairs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..tr <- jmvcore::OptionNumber$new(
                "tr",
                tr,
                min=0,
                max=0.5,
                default=0.2)
            private$..md <- jmvcore::OptionBool$new(
                "md",
                md,
                default=FALSE)
            private$..es <- jmvcore::OptionBool$new(
                "es",
                es,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
        
            self$.addOption(private$..pairs)
            self$.addOption(private$..tr)
            self$.addOption(private$..md)
            self$.addOption(private$..es)
            self$.addOption(private$..ci)
        }),
    active = list(
        pairs = function() private$..pairs$value,
        tr = function() private$..tr$value,
        md = function() private$..md$value,
        es = function() private$..es$value,
        ci = function() private$..ci$value),
    private = list(
        ..pairs = NA,
        ..tr = NA,
        ..md = NA,
        ..es = NA,
        ..ci = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
rttestPSResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$..ttest),
    private = list(
        ..ttest = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Robust Paired Samples T-Test")
            private$..ttest <- jmvcore::Table$new(
                options=options,
                name="ttest",
                title="Robust Paired Samples T-Test",
                rows="(pairs)",
                clearWith=list(
                    "tr"),
                columns=list(
                    list(`name`="var1", `title`="", `type`="text"),
                    list(`name`="var2", `title`="", `type`="text"),
                    list(`name`="t", `title`="t"),
                    list(`name`="df", `title`="df", `type`="number"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="md", `title`="Mean difference", `visible`="(md)"),
                    list(`name`="se", `title`="SE", `visible`="(md)"),
                    list(`name`="cil", `title`="Lower", `superTitle`="95% Confidence Interval", `visible`="(ci)"),
                    list(`name`="ciu", `title`="Upper", `superTitle`="95% Confidence Interval", `visible`="(ci)"),
                    list(`name`="es", `title`="Cohen's d", `visible`="(es)")))
            self$add(private$..ttest)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
rttestPSBase <- R6::R6Class(
    "rttestPSBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'walrus',
                name = 'rttestPS',
                version = c(1,0,0),
                options = options,
                results = rttestPSResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Robust Paired Samples T-Test
#'
#' Robust Paired Samples T-Test
#'
#' @examples
#' data(anorexia, package='MASS')
#' anorexiaFT <- subset(anorexia, subset = Treat == "FT")
#' 
#' rttestPS(anorexiaFT,
#'          pairs = list(
#'              list(i1 = 'Prewt', i2 = 'Postwt')))
#' 
#' #
#' #  ROBUST PAIRED SAMPLES T-TEST
#' #
#' #  Robust Paired Samples T-Test
#' #  ---------------------------------------------
#' #                       t        df      p
#' #  ---------------------------------------------
#' #    Prewt    Postwt    -3.83    10.0    0.003
#' #  ---------------------------------------------
#' #
#' 
#' @param data the data as a data frame
#' @param pairs a list of lists specifying the pairs of measurement in 
#'   \code{data}
#' @param tr a number between 0 and 0.5, (default: 0.2), the proportion of 
#'   measurements to trim from each end, when using the trim and bootstrap 
#'   methods 
#' @param md \code{TRUE} or \code{FALSE} (default), provide means and standard 
#'   errors 
#' @param es \code{TRUE} or \code{FALSE} (default), provide effect sizes 
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence 
#'   intervals 
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$ttest} \tab \tab \tab \tab \tab the table of t-test results \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$ttest$asDF}
#'
#' \code{as.data.frame(results$ttest)}
#'
#' @export
rttestPS <- function(
    data,
    pairs,
    tr = 0.2,
    md = FALSE,
    es = FALSE,
    ci = FALSE) {

    options <- rttestPSOptions$new(
        pairs = pairs,
        tr = tr,
        md = md,
        es = es,
        ci = ci)

    results <- rttestPSResults$new(
        options = options)

    analysis <- rttestPSClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
