% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move.imgs.R
\name{move.imgs}
\alias{move.imgs}
\title{Move/copy image files between directories}
\usage{
move.imgs(from = NULL, to = NULL, it = "all", cut = TRUE, 
overwrite = FALSE, create.folder = TRUE, folder.name = "image_files")
}
\arguments{
\item{from}{Directory path where image files to be copied are found. 
If \code{NULL} (default) then the current working directory is used.}

\item{to}{Directory path where image files will be copied to.}

\item{it}{A character vector of length 1 giving the image type to be used. "all",
"tiff", "jpeg" and "pdf" are admitted ("all" includes all the rest). Default is "all".}

\item{cut}{Logical. Determines if files are removed from the original location after
being copied (cut) or not (just copied). Default is \code{TRUE}.}

\item{overwrite}{Logical. Determines if files that already exist in the destination directory 
should be overwritten. Default is \code{FALSE}.}

\item{create.folder}{Logical. Determines if are moved to a new folder (which is named with the
"folder.name" argument). Ignored if 'to' is provided. Default is \code{TRUE}.}

\item{folder.name}{Character string with the name of the new folder where the files will be 
copied to. Ignored if 'to' is provided. Default is \code{"image_files"}.}
}
\description{
\code{move.imgs} Move/copy image files created by \code{\link{warbleR}} between 
directories (folders).
}
\details{
This function aims to simplify the manipulation of the image files produce by many 
of the \code{\link{warbleR}} function. It copies/cuts files between directories.
}
\examples{
{
#Set temporary working directory
setwd(tempdir())

#load data
data("Cryp.soui")
writeWave(Cryp.soui, "Cryp.soui.wav") #save sound files 

#autodetec location of signals
ad <- autodetec(threshold = 6, bp = c(1, 3), mindur = 1.2,
maxdur = 3, img = FALSE, ssmooth = 600, wl = 300, flist = "Cryp.soui.wav")

#track dominant frequency graphs with freq reange detection
trackfreqs(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, it = "tiff",
bp = c(1, 3), contour = "df", wl = 300, frange = TRUE)

#copy files
move.imgs(cut = FALSE)

#cut files
move.imgs(cut = TRUE, to = "image_files")

# Check this folder
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{filtersels}}
}

