% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectangular_warehouse_from_copras_locations.R
\name{rectangular_warehouse_from_copras_locations}
\alias{rectangular_warehouse_from_copras_locations}
\title{Create a Rectangular Warehouse Layout from COPRAS Locations}
\usage{
rectangular_warehouse_from_copras_locations(
  locations,
  warehouse_width,
  warehouse_height
)
}
\arguments{
\item{locations}{A numeric vector representing the COPRAS-assigned locations of items in the warehouse.}

\item{warehouse_width}{An integer specifying the width of the warehouse.}

\item{warehouse_height}{An integer specifying the height of the warehouse.}
}
\value{
A matrix representing the rectangular warehouse layout. Each row corresponds to a coordinate in the warehouse.
}
\description{
This function generates a rectangular warehouse layout matrix based on COPRAS-assigned locations, given the warehouse dimensions.
}
\details{
The function maps the given COPRAS-assigned item locations to a rectangular warehouse layout. The x and y coordinates are calculated based on the warehouse dimensions and adjusted for the warehouse structure. Additional rows are added for boundary positions at the top and bottom of the warehouse.

The resulting matrix contains the following columns:
- `x`: The x-coordinate (column) of the warehouse.
- `y`: The y-coordinate (row) of the warehouse.

The matrix is sorted by x and y coordinates and ensures unique rows in the layout.
}
\examples{
# Example usage
locations <- c(1, 5, 10, 15)
warehouse_width <- 8
warehouse_height <- 4
rectangular_warehouse_from_copras_locations(locations, warehouse_width, warehouse_height)

}
\references{
Gudehus, T., & Kotzab, H. (2012). *Comprehensive Logistics*. Springer Berlin Heidelberg.
\doi{10.1007/978-3-642-24367-7}

Zavadskas, E. K., Kaklauskas, A., & Šarka, V. (1994). The new method of multicriteria complex proportional assessment projects.
In E. K. Zavadskas & P. Linnert (Eds.), *Technological and economic development of economy. Volume 3. Business Management* (pp. 131–140). Vilnius: „Technika”.
}
\author{
Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}

Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

scenario2 <- generate_sample_goods_and_locatons_scenario(warehouse_height = 10,warehouse_width = 10,nr_goods = 5)
copras <- copras_assignment(scenario2)
locations<-unique(unlist(lapply(copras, function(x)\{return(x$copras$location)\} )))
coordinates <-  rectangular_warehouse_from_copras_locations(locations,warehouse_height = 10,warehouse_width = 10)
}
